/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.model;

public class OperationDescriptor extends DescriptorElement {

  private String method;
  private String name;
  private String description;
  private String inputMediaType;
  private String outputMediaType;
  private RequestDescriptor expects;
  private boolean ignored;
  private String baseUri;
  private TriggerDescriptor trigger;
  private String pagination;
  private Boolean skipOutputTypeValidation;
  private String inputTypeSchema;
  private String outputTypeSchema;

  public OperationDescriptor(String method, String name, String description, String inputMediaType, String outputMediaType,
                             RequestDescriptor expects, boolean ignored, String alternativeBaseUri, String pagination,
                             Boolean skipOutputTypeValidation, String inputTypeSchema, String outputTypeSchema) {
    this.method = method;
    this.name = name;
    this.description = description;
    this.inputMediaType = inputMediaType;
    this.outputMediaType = outputMediaType;
    this.expects = expects;
    this.ignored = ignored;
    this.baseUri = alternativeBaseUri;
    this.pagination = pagination;
    this.skipOutputTypeValidation = skipOutputTypeValidation;
    this.inputTypeSchema = inputTypeSchema;
    this.outputTypeSchema = outputTypeSchema;
  }

  public String getMethod() {
    return method;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public String getInputMediaType() {
    return inputMediaType;
  }

  public String getOutputMediaType() {
    return outputMediaType;
  }

  public RequestDescriptor getExpects() {
    return expects;
  }

  public boolean isIgnored() {
    return ignored;
  }

  public String getBaseUri() {
    return baseUri;
  }

  public TriggerDescriptor getTrigger() {
    return trigger;
  }

  public String getPagination() {
    return pagination;
  }

  public Boolean getSkipOutputTypeValidation() {
    return skipOutputTypeValidation;
  }

  public String getInputTypeSchema() {
    return inputTypeSchema;
  }

  public String getOutputTypeSchema() {
    return outputTypeSchema;
  }
}
