/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;

import java.util.List;

/**
 * This class consists exclusively of method that return the connector category parsing the rest connect vocabulary
 *
 * @author Marcelo Vlaicevich
 *
 */
public class DescriptorConnectorCategoryParser {

  private static final String CONNECTOR_CATEGORY = "http://a.ml/vocabularies/restConnect#connectorCategory";


  public String parseConnectorCategory(DialectDomainElement element) {
    List<Object> urls = element.getScalarByPropertyUri(CONNECTOR_CATEGORY);
    return urls.isEmpty() ? null : urls.get(0).toString();
  }
}
