/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;

import java.util.List;

public class DescriptorCustomJavaPackageParser {

  private static final String CUSTOM_JAVA_PACKAGE = "http://a.ml/vocabularies/restConnect#baseJavaPackage";

  public String parseJavaPackage(DialectDomainElement element) {
    List<Object> urls = element.getScalarByPropertyUri(CUSTOM_JAVA_PACKAGE);
    return urls.isEmpty() ? null : urls.get(0).toString();
  }

}
