/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import static org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils.parseAlternativeBaseUri;
import static org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils.parseRestConnectIgnored;
import static org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel.buildStandardPath;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import amf.client.model.domain.DialectDomainElement;

class DescriptorEndpointParser {

  private static final String API_CONTRACT_ENDPOINT = "http://a.ml/vocabularies/apiContract#endpoint";
  private static final String API_CONTRACT_PATH = "http://a.ml/vocabularies/apiContract#path";
  private DescriptorOperationParser descriptorOperationParser = new DescriptorOperationParser();

  public List<EndPointDescriptor> parseEndpoints(DialectDomainElement encodes, Path descriptorFilePath)
      throws ModelGenerationException {
    List<EndPointDescriptor> endpointDescriptors = new ArrayList<>();

    for (DialectDomainElement x : getEndpoints(encodes)) {
      endpointDescriptors.add(parseEndpoint(x, descriptorFilePath));
    }

    return endpointDescriptors;
  }

  private EndPointDescriptor parseEndpoint(DialectDomainElement endpointElement, Path descriptorFilePath)
      throws ModelGenerationException {
    return new EndPointDescriptor(
                                  getEndpointPath(endpointElement),
                                  descriptorOperationParser.parseOperations(endpointElement, descriptorFilePath),
                                  parseRestConnectIgnored(endpointElement),
                                  parseAlternativeBaseUri(endpointElement));
  }

  private List<DialectDomainElement> getEndpoints(DialectDomainElement encodes) {
    return encodes.getObjectPropertyUri(API_CONTRACT_ENDPOINT);
  }

  private String getEndpointPath(DialectDomainElement endpointElement) {
    return buildStandardPath(endpointElement.getScalarByPropertyUri(API_CONTRACT_PATH).get(0).toString());
  }

}
