/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;

import java.util.List;


/**
 * This class consists exclusively of method that return the extension xml prefix contento parsing the rest connect vocabulary
 *
 * @author Marcelo Vlaicevich
 *
 */
public class DescriptorExtensionXmlParser {

  private static final String EXTENSION_XML = "http://a.ml/vocabularies/restConnect#extensionXml";

  public String parseExtensionXml(DialectDomainElement element) {
    List<Object> urls = element.getScalarByPropertyUri(EXTENSION_XML);
    return urls.isEmpty() ? null : urls.get(0).toString();
  }
}
