/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorSkipOutputTypeValidationParser {

  private static final String SKIP_OUTPUT_TYPE_VALIDATION = "http://a.ml/vocabularies/restConnect#skipOutputTypeValidation";

  public Boolean parseSkipOutputTypeValidation(DialectDomainElement element) {
    List<Object> skipOutputTypeValidations = element.getScalarByPropertyUri(SKIP_OUTPUT_TYPE_VALIDATION);
    return skipOutputTypeValidations.isEmpty() ? null : Boolean.parseBoolean(skipOutputTypeValidations.get(0).toString());
  }
}
