/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.OutPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.PaginationParameter;
import org.mule.connectors.restconnect.commons.api.operation.paging.OffsetPagingProvider;

import java.nio.file.Path;


public class SdkOffsetPaginationOperation extends AbstractSdkPaginationOperation {

  public static final String OFFSET_PARAM_NAME = "offsetParamName";
  public static final String INITIAL_OFFSET = "initialOffset";

  public SdkOffsetPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                      ConnectorOperation operation) {
    super(outputDir, connectorModel, sdkConnector, operation);
  }

  @Override
  public String getInitialPagingParameterSummary() {
    return "the initial offset to apply on the first request";
  }

  @Override
  public Class getPagingProvider() {
    return OffsetPagingProvider.class;
  }

  @Override
  public String getTokenParamName() {
    PaginationParameter parameter = getPagination().getParameter(OFFSET_PARAM_NAME);

    return (parameter == null) ? "0" : ((OutPaginationParameter) parameter).getValue();
  }

  @Override
  public String getInitialParamName() {
    return INITIAL_OFFSET;
  }
}
