/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.util;

import java.io.File;
import java.io.IOException;
import java.util.Date;

import static com.google.common.base.Charsets.UTF_8;
import static org.apache.commons.io.FileUtils.writeStringToFile;

public class FileUtils {

  private FileUtils() {}

  public static File createTempFile(String content) throws IOException {
    File file = File.createTempFile(getTempName(), ".tmp");
    writeStringToFile(file, content, UTF_8);
    file.deleteOnExit();
    return file;
  }

  private static String getTempName() {
    return String.valueOf(new Date().getTime());
  }

}
