/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation;

import static org.apache.commons.lang3.StringUtils.EMPTY;
import org.mule.connectivity.restconnect.internal.validation.rules.R001Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R002Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R003Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R004Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R005Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R006Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R007Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R008Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R009Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R010Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R011Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R012Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R013Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R014Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R015Validator;
import org.mule.connectivity.restconnect.internal.validation.rules.R016Validator;

public enum ModelValidationRules {

  R001("R001",
      "Descriptor PATHs must be present in the API spec",
      "Any path declared in the connector descriptor must be present in the API spec.",
      Level.ERROR,
      new R001Validator()),

  R002("R002",
      "Descriptor operations must be present in the API spec",
      "Any operation (PATH + METHOD) declared in the connector descriptor must be present in the API spec.",
      Level.ERROR,
      new R002Validator()),

  R003("R003",
      "Operations must declare a body",
      "GET, POST, PATCH and OPTIONS operations defined in the API spec must declare a body and a type. "
          + "If they don't, the connector descriptor must skip this check or define a body for that operation.",
      Level.ERROR,
      new R003Validator()),

  R004("R004",
      "At least one of the declared security schemes must be supported",
      "When the API spec declares security, at least one of the declared security schemes must be supported.",
      Level.ERROR,
      new R004Validator()),

  R005("R005",
      "Descriptor extensionXml property must be xml valid",
      "When present in the connector descriptor, extensionXml property must be a xml valid name.",
      Level.ERROR,
      new R005Validator()),

  R006("R006",
      "Descriptor baseJavaPackage must ve a valid java package name",
      "When present in the connector descriptor, baseJavaPackage property must be a valid java package.",
      Level.ERROR,
      new R006Validator()),

  R007("R007",
      "Descriptor connectorGav's groupId must ve a valid Maven groupId",
      "The groupId defined in the connector descriptor for the connectorGav must ve a valid java package name.",
      Level.ERROR,
      new R007Validator()),

  R008("R008",
      "Descriptor connectorGav's artifactId must ve a valid Maven artifactId",
      "The artifactId defined in the connector descriptor for the connectorGav can contain lowercase letters and no strange symbols.",
      Level.ERROR,
      new R008Validator()),

  R009("R009",
      "Descriptor connectorGav's version must ve a valid Maven version",
      "The version defined in the connector descriptor for the connectorGav can contain numbers, dots, dashes, letters and no strange symbols.",
      Level.ERROR,
      new R009Validator()),

  R010("R010",
      "The API spec defines a security scheme that is not supported",
      EMPTY,
      Level.WARN,
      new R010Validator()),

  R011("R011",
      "connectorName property seems not to be a friendly name",
      "The connectorName declared in the descriptor should be a human readable name separated with spaces.",
      Level.ERROR,
      new R011Validator()),

  R012("R012",
      "Operation display name seems not to be a friendly name",
      "The displayName should be a human readable name separated with spaces.",
      Level.ERROR,
      new R012Validator()),

  R013("R013",
      "Parameter display name seems not to be a friendly name",
      "The displayName should be a human readable name separated with spaces.",
      Level.WARN,
      new R013Validator()),

  R014("R014",
      "No default inputMediaType was set in the Descriptor and multiple are available",
      EMPTY,
      Level.INFO,
      new R014Validator()),

  R015("R015",
      "No default outputMediaType was set in the Descriptor and multiple are available",
      EMPTY,
      Level.INFO,
      new R015Validator()),

  R016("R016",
      "Operation parameters declared in the connector descriptor must be present in the API spec",
      EMPTY,
      Level.ERROR,
      new R016Validator());

  private String code;
  private String summary;
  private String description;
  private Level level;
  private RuleValidator ruleValidator;

  ModelValidationRules(String code, String summary, String description, Level level, RuleValidator ruleValidator) {
    this.code = code;
    this.summary = summary;
    this.description = description;
    this.level = level;
    this.ruleValidator = ruleValidator;
  }

  public String getCode() {
    return code;
  }

  public String getSummary() {
    return summary;
  }

  public String getDescription() {
    return description;
  }

  public Level getLevel() {
    return level;
  }

  public RuleValidator getRuleValidator() {
    return ruleValidator;
  }

  public enum Level {
    INFO, WARN, ERROR
  }
}
