/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation;

import static java.util.Arrays.stream;
import static java.util.stream.Collectors.toList;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.List;
import java.util.Objects;

public class ModelValidator {

  private List<RuleValidator> validators;

  public ModelValidator() {
    this(stream(ModelValidationRules.values()).collect(toList()));
  }

  public ModelValidator(List<ModelValidationRules> rules) {
    this.validators = rules.stream()
        .map(ModelValidationRules::getRuleValidator)
        .filter(Objects::nonNull)
        .collect(toList());
  }

  public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor, APIModel apiModel,
                                         ConnectorModel connectorModel) {
    return validators
        .stream()
        .flatMap(x -> x.validate(connectorDescriptor, apiModel, connectorModel).stream())
        .collect(toList());
  }
}
