/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation;

import static java.lang.String.format;
import static java.lang.System.lineSeparator;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

public class ValidationResult {

  private ModelValidationRules rule;
  private String location;

  public ValidationResult(ModelValidationRules rule, String location) {
    this.rule = rule;
    this.location = location;
  }

  public ModelValidationRules.Level getLevel() {
    return this.rule.getLevel();
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    StringBuilder stringBuilder =
        new StringBuilder(format("[%s] %s - %s", rule.getLevel().name(), rule.getCode(), rule.getSummary()));
    stringBuilder.append(lineSeparator());

    if (isNotBlank(rule.getDescription())) {
      stringBuilder
          .append(rule.getDescription())
          .append(lineSeparator());
    }

    stringBuilder
        .append("Location: ")
        .append(location);

    return stringBuilder.toString();
  }
}
