/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static java.util.stream.Collectors.toList;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

import java.util.LinkedList;
import java.util.List;

public class R001Validator implements RuleValidator {

  @Override
  public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor,
                                         APIModel apiModel,
                                         ConnectorModel connectorModel) {
    List<String> descriptorPaths =
        connectorDescriptor.getEndpoints().stream()
            .map(EndPointDescriptor::getPath)
            .collect(toList());

    List<String> apiPaths = apiModel.getOperationsModel().stream()
        .map(APIOperationModel::getPath)
        .distinct()
        .collect(toList());

    List<ValidationResult> validationResults = new LinkedList<>();

    for (String descriptorPath : descriptorPaths) {
      if (apiPaths.stream().noneMatch(x -> x.equalsIgnoreCase(descriptorPath))) {
        validationResults.add(new ValidationResult(ModelValidationRules.R001, "Path: " + descriptorPath));
      }
    }

    return validationResults;
  }
}
