/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static java.util.stream.Collectors.toList;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.LinkedList;
import java.util.List;

import javafx.util.Pair;

public class R002Validator implements RuleValidator {

  @Override
  public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor,
                                         APIModel apiModel,
                                         ConnectorModel connectorModel) {
    List<Pair<String, String>> descriptorOperations =
        connectorDescriptor.getEndpoints().stream()
            .flatMap(x -> x.getOperations().stream().map(y -> new Pair<>(x.getPath(), y.getMethod())))
            .collect(toList());

    List<Pair<String, String>> apiOperations = apiModel.getOperationsModel().stream()
        .map(x -> new Pair<>(x.getPath(), x.getHttpMethod().name()))
        .distinct()
        .collect(toList());

    List<ValidationResult> validationResults = new LinkedList<>();

    for (Pair<String, String> descriptorOperation : descriptorOperations) {
      if (apiOperations.stream().noneMatch(
                                           x -> x.getKey().equalsIgnoreCase(descriptorOperation.getKey())
                                               && x.getValue().equalsIgnoreCase(descriptorOperation.getValue()))) {
        validationResults.add(
                              new ValidationResult(ModelValidationRules.R002,
                                                   "Path: " + descriptorOperation.getKey() + " - Method: "
                                                       + descriptorOperation.getValue()));
      }
    }

    return validationResults;
  }
}
