/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static org.mule.connectivity.restconnect.internal.validation.ModelValidationRules.R009;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

import java.util.LinkedList;
import java.util.List;

public class R009Validator implements RuleValidator {

  @Override
  public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor,
                                         APIModel apiModel,
                                         ConnectorModel connectorModel) {

    List<ValidationResult> validationResults = new LinkedList<>();

    String version = connectorDescriptor.getConnectorGav().getVersion();
    String validVersion = XmlUtils.removeMavenVersionUnwantedCharacters(version);

    if (!version.equalsIgnoreCase(validVersion)) {
      validationResults.add(getValidationError());
    }

    return validationResults;
  }

  private ValidationResult getValidationError() {
    return new ValidationResult(R009, "'version' property declared in the connector descriptor's 'connectorGav' property");
  }
}
