/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static java.util.stream.Collectors.toList;
import static org.mule.connectivity.restconnect.internal.validation.ModelValidationRules.R010;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.security.NotSupportedScheme;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

import java.util.List;

public class R010Validator implements RuleValidator {

  @Override
  public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor,
                                         APIModel apiModel,
                                         ConnectorModel connectorModel) {

    return apiModel.getOperationsModel().stream()
        .filter(this::anySecuritySchemeNotSupported)
        .map(this::getValidationError)
        .collect(toList());
  }

  private boolean anySecuritySchemeNotSupported(APIOperationModel apiOperationModel) {
    return !apiOperationModel.getSecuritySchemesModel().isEmpty() &&
        apiOperationModel.getSecuritySchemesModel().stream()
            .anyMatch(x -> x.getSecuritySchemeClass().equals(NotSupportedScheme.class));
  }

  private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
    String location =
        "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();

    return new ValidationResult(R010, location);
  }
}
