/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.model;

import org.mule.connectivity.restconnect.internal.connectormodel.security.APISecurityScheme;

import java.util.List;

public abstract class APISecuritySchemeModel {

  protected String displayName;
  protected Class<? extends APISecurityScheme> securitySchemeClass;
  protected List<APIParameterModel> customQueryParams;
  protected List<APIParameterModel> customHeaders;
  protected String authorizationUri;
  protected String accessTokenUri;
  protected List<String> scopes;

  public String getDisplayName() {
    return displayName;
  }

  public Class<? extends APISecurityScheme> getSecuritySchemeClass() {
    return securitySchemeClass;
  }

  public List<APIParameterModel> getCustomQueryParams() {
    return customQueryParams;
  }

  public List<APIParameterModel> getCustomHeaders() {
    return customHeaders;
  }

  public String getAuthorizationUri() {
    return authorizationUri;
  }

  public String getAccessTokenUri() {
    return accessTokenUri;
  }

  public List<String> getScopes() {
    return scopes;
  }
}
