/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import static org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils.isXmlSchema;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.SchemaShape;
import amf.plugins.xml.transformer.TypeToXmlSchema;
import org.apache.ws.commons.schema.XmlSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeSchemaModel;

import javax.ws.rs.core.MediaType;
import java.io.StringWriter;

public class AMFTypeSchemaModel extends APITypeSchemaModel {

  public AMFTypeSchemaModel(AnyShape shape, MediaType mediaType) {
    this.typeSchema = buildTypeSchema(shape, mediaType);
  }

  private TypeSchema buildTypeSchema(AnyShape shape, MediaType mediaType) {

    TypeSchema newTypeSchema;

    if (shape instanceof SchemaShape && ((SchemaShape) shape).raw().nonEmpty()) {
      SchemaShape schemaShape = (SchemaShape) shape;

      if (isXmlSchemaShape(schemaShape)) {
        newTypeSchema = buildXmlTypeSchema(schemaShape);
      } else {
        newTypeSchema = new JsonTypeSchema(schemaShape.raw().value());
      }
    }

    else if (MediaType.APPLICATION_JSON_TYPE.equals(mediaType)) {
      newTypeSchema = new JsonTypeSchema(shape.buildJsonSchema());
    }

    else if (MediaType.APPLICATION_XML_TYPE.equals(mediaType)) {
      newTypeSchema = buildXmlTypeSchema(shape);
    }

    else {
      newTypeSchema = new JsonTypeSchema(shape.buildJsonSchema());
    }

    return newTypeSchema;
  }

  public static boolean isXmlSchemaShape(SchemaShape schemaShape) {
    return schemaShape.raw().nonEmpty() && isXmlSchema(schemaShape.raw().value());
  }

  private TypeSchema buildXmlTypeSchema(SchemaShape schemaShape) {

    String elementName = schemaShape.annotations().fragmentName().orElse(null);
    String path = schemaShape.location().orElse(null);

    return new XmlTypeSchema(schemaShape.raw().value(), elementName, path);
  }

  private TypeSchema buildXmlTypeSchema(AnyShape anyShape) {
    XmlSchema xmlSchema = TypeToXmlSchema.transform("root", anyShape._internal());
    xmlSchema.setTargetNamespace("http://validationnamespace.raml.org");

    StringWriter schemaWriter = new StringWriter();
    xmlSchema.write(schemaWriter);
    String schemaString = schemaWriter.toString();

    return new XmlTypeSchema(schemaString);
  }
}
