/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf.util;

import org.mule.connectivity.restconnect.internal.webapi.util.ParserUtils;

import amf.client.model.domain.Shape;

public class AMFParserUtil extends ParserUtils {

  public static Shape getActualShape(Shape shape) {

    if (shape != null && shape.isLink()) {
      Shape auxShape = (Shape) shape.linkTarget().orElse(null);

      if (auxShape != null) {
        return getActualShape(auxShape);
      }
    }

    return shape;
  }

}
