/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import static org.apache.commons.lang.StringUtils.isNotBlank;

import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeSchemaModel;
import org.raml.v2.api.model.v10.datamodel.ExternalTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;

import javax.ws.rs.core.MediaType;

public class RPTypeSchemaModel extends APITypeSchemaModel {

  public RPTypeSchemaModel(TypeDeclaration typeDeclaration, MediaType mediaType) {
    this.typeSchema = buildTypeSchema(typeDeclaration, mediaType);
  }

  private TypeSchema buildTypeSchema(TypeDeclaration typeDeclaration, MediaType mediaType) {

    TypeSchema newTypeSchema;

    if (typeDeclaration instanceof ExternalTypeDeclaration
        && isNotBlank(((ExternalTypeDeclaration) typeDeclaration).schemaContent())) {

      ExternalTypeDeclaration externalTypeDeclaration = ((ExternalTypeDeclaration) typeDeclaration);

      if (typeDeclaration instanceof XMLTypeDeclaration) {
        newTypeSchema = buildXmlTypeSchema((XMLTypeDeclaration) typeDeclaration);
      } else {
        //(typeDeclaration instanceof JSONTypeDeclaration)
        newTypeSchema = new JsonTypeSchema(externalTypeDeclaration.schemaContent());
      }
    }

    else if (MediaType.APPLICATION_JSON_TYPE.equals(mediaType)) {
      newTypeSchema = new JsonTypeSchema(typeDeclaration.toJsonSchema());
    }

    else if (MediaType.APPLICATION_XML_TYPE.equals(mediaType)) {
      newTypeSchema = new XmlTypeSchema(typeDeclaration.toXmlSchema());
    }

    else {
      //By default we create a json schema for any type definition
      newTypeSchema = new JsonTypeSchema(typeDeclaration.toJsonSchema());
    }

    return newTypeSchema;
  }

  private static TypeSchema buildXmlTypeSchema(XMLTypeDeclaration xmlTypeDeclaration) {
    String elementName =
        isNotBlank(xmlTypeDeclaration.internalFragment()) ? xmlTypeDeclaration.internalFragment() : null;
    String path = xmlTypeDeclaration.schemaPath();

    return new XmlTypeSchema(xmlTypeDeclaration.schemaContent(), elementName, path);
  }
}
