/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.util;

import static java.util.stream.Collectors.toList;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

import java.util.LinkedList;
import java.util.List;

public class RPOperationMappingUtils {

  private RPOperationMappingUtils() {}

  /**
   * Traverses the RAML and extracts all actions that will eventually become operations
   * @param api The RAMLParser API
   */
  public static List<Method> getMethods(Api api) {
    return getAllResources(api).stream().flatMap(x -> x.methods().stream()).collect(toList());
  }

  private static List<Resource> getAllResources(Api api) {
    List<Resource> allResources = new LinkedList<>(api.resources());

    for (Resource resource : api.resources()) {
      allResources.addAll(getSubResources(resource));
    }

    return allResources;
  }

  private static List<Resource> getSubResources(Resource resource) {
    List<Resource> subResources = new LinkedList<>(resource.resources());

    for (Resource r : resource.resources()) {
      subResources.addAll(getSubResources(r));
    }

    return subResources;
  }
}
