/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.api;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorModelBuilder;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParser;
import org.mule.connectivity.restconnect.internal.templating.TemplateEntity;
import org.mule.connectivity.restconnect.internal.util.AMFWrapper;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.ModelValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ApiParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnect {
    private static Logger logger = LoggerFactory.getLogger(RestConnect.class);

    private RestConnect() {
    }

    public static ConnectorModel getConnectorModel(File descriptor, File spec, SpecFormat format, Parser parser, String rootDir) throws ModelGenerationException {
        AMFWrapper.initialize();
        DescriptorParser descriptorParser = new DescriptorParser();
        ConnectorDescriptor connectorDescriptor = descriptorParser.parseConnectorDescriptor(descriptor);
        APIModel apiModel = ApiParser.parseModel(spec, format, parser, rootDir);
        ConnectorModelBuilder connectorModelBuilder = new ConnectorModelBuilder();
        ConnectorModel connectorModel = connectorModelBuilder.buildConnectorModel(apiModel, connectorDescriptor);
        if (RestConnect.validateModel(connectorDescriptor, apiModel, connectorModel)) {
            return connectorModel;
        }
        return null;
    }

    public static void generateConnector(ConnectorModel connectorModel, ConnectorType connectorType, Path outputDir, Path descriptorPath) throws TemplatingException {
        TemplateEntity.getTemplateEngine(connectorType, connectorModel, outputDir, descriptorPath).applyTemplates();
    }

    private static boolean validateModel(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        ModelValidator modelValidator = new ModelValidator();
        List<ValidationResult> validationResults = modelValidator.validate(connectorDescriptor, apiModel, connectorModel);
        List<ValidationResult> errorList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ModelValidationRules.Level.ERROR)).collect(Collectors.toList());
        List<ValidationResult> warnList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ModelValidationRules.Level.WARN)).collect(Collectors.toList());
        List<ValidationResult> infoList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ModelValidationRules.Level.INFO)).collect(Collectors.toList());
        errorList.forEach(x -> logger.error(x.toString() + System.lineSeparator()));
        warnList.forEach(x -> logger.warn(x.toString() + System.lineSeparator()));
        infoList.forEach(x -> logger.warn(x.toString() + System.lineSeparator()));
        return errorList.isEmpty();
    }
}

