/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorParameterBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorTypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.connectormodel.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.NotSupportedScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.webapi.model.APISecuritySchemeModel;

public class ConnectorSecuritySchemeBuilder {
    private final ConnectorParameterBuilder parameterBuilder;

    public ConnectorSecuritySchemeBuilder(ConnectorTypeDefinitionBuilder connectorTypeDefinitionBuilder) {
        this.parameterBuilder = new ConnectorParameterBuilder(connectorTypeDefinitionBuilder);
    }

    public List<APISecurityScheme> buildSecuritySchemes(List<APISecuritySchemeModel> apiSecuritySchemeModels) throws ModelGenerationException {
        LinkedList<APISecurityScheme> apiSecuritySchemes = new LinkedList<APISecurityScheme>();
        if (!apiSecuritySchemeModels.isEmpty()) {
            for (APISecuritySchemeModel securitySchemeModel : apiSecuritySchemeModels) {
                APISecurityScheme apiSecurityScheme = this.buildSecurityScheme(securitySchemeModel);
                if (apiSecurityScheme instanceof NotSupportedScheme) continue;
                apiSecuritySchemes.add(apiSecurityScheme);
            }
        } else {
            apiSecuritySchemes.add(new UnsecuredScheme());
        }
        return apiSecuritySchemes;
    }

    private APISecurityScheme buildSecurityScheme(APISecuritySchemeModel securitySchemeModel) throws ModelGenerationException {
        Class<? extends APISecurityScheme> securitySchemeClass = securitySchemeModel.getSecuritySchemeClass();
        LinkedList<String> collisionNames = new LinkedList<String>();
        List<Parameter> customQueryParams = this.parameterBuilder.buildParameterList(securitySchemeModel.getCustomQueryParams(), null, collisionNames);
        collisionNames.addAll(customQueryParams.stream().map(Parameter::getInternalName).collect(Collectors.toList()));
        List<Parameter> customHeaders = this.parameterBuilder.buildParameterList(securitySchemeModel.getCustomHeaders(), null, collisionNames);
        APISecurityScheme.Builder builder = APISecurityScheme.builder(securitySchemeModel.getDisplayName(), customQueryParams, customHeaders);
        if (securitySchemeClass.equals(BasicAuthScheme.class)) {
            return builder.buildBasicAuthScheme();
        }
        if (securitySchemeClass.equals(CustomAuthenticationScheme.class)) {
            return builder.buildCustomAuthenticationScheme();
        }
        if (securitySchemeClass.equals(DigestAuthenticationScheme.class)) {
            return builder.buildDigestAuthenticationSchemeScheme();
        }
        if (securitySchemeClass.equals(OAuth2AuthorizationCodeScheme.class)) {
            return builder.buildOAuth2AuthorizationCodeScheme(securitySchemeModel.getAuthorizationUri(), securitySchemeModel.getAccessTokenUri(), securitySchemeModel.getScopes());
        }
        if (securitySchemeClass.equals(OAuth2ClientCredentialsScheme.class)) {
            return builder.buildOAuth2ClientCredentialsScheme(securitySchemeModel.getAuthorizationUri(), securitySchemeModel.getAccessTokenUri(), securitySchemeModel.getScopes());
        }
        if (securitySchemeClass.equals(PassThroughScheme.class)) {
            return builder.buildPassThroughScheme();
        }
        return builder.buildUnsecuredScheme();
    }
}

