/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import java.util.ArrayList;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorParameterBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorTypeSchemaBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ArrayTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.MultipartTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ObjectTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.UnionTypeDefinition;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIPrimitiveTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.TypeSchemaPool;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class ConnectorTypeDefinitionBuilder {
    private final ConnectorTypeSchemaBuilder typeSchemaBuilder;
    private final ConnectorParameterBuilder parameterBuilder;

    public ConnectorTypeDefinitionBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeSchemaBuilder = new ConnectorTypeSchemaBuilder(typeSchemaPool);
        this.parameterBuilder = new ConnectorParameterBuilder(this);
    }

    public TypeDefinition buildTypeDefinition(APITypeModel apiTypeModel) throws ModelGenerationException {
        TypeDefinition.Builder typeDefinitionBuilder = TypeDefinition.builder(apiTypeModel.getMediaType(), this.typeSchemaBuilder.buildTypeSchema(apiTypeModel.getAPITypeSchemaModel()), apiTypeModel.getEnumValues(), apiTypeModel.getExample());
        Class<? extends TypeDefinition> typeDefinitionClass = apiTypeModel.getTypeDefinitionClass();
        if (typeDefinitionClass == null) {
            return null;
        }
        if (typeDefinitionClass.equals(EmptyTypeDefinition.class)) {
            return typeDefinitionBuilder.buildEmptyTypeDefinition();
        }
        if (typeDefinitionClass.equals(PrimitiveTypeDefinition.class)) {
            return typeDefinitionBuilder.buildPrimitiveTypeDefinition(this.buildPrimitiveType(apiTypeModel.getPrimitiveTypeModel()));
        }
        if (typeDefinitionClass.equals(ObjectTypeDefinition.class)) {
            return typeDefinitionBuilder.buildObjectTypeDefinition();
        }
        if (typeDefinitionClass.equals(ArrayTypeDefinition.class)) {
            return typeDefinitionBuilder.buildArrayType(this.buildTypeDefinition(apiTypeModel.getInnerType()));
        }
        if (typeDefinitionClass.equals(UnionTypeDefinition.class)) {
            ArrayList<TypeDefinition> unionTypes = new ArrayList<TypeDefinition>();
            for (APITypeModel typeModel : apiTypeModel.getUnionTypes()) {
                TypeDefinition typeDefinition = this.buildTypeDefinition(typeModel);
                unionTypes.add(typeDefinition);
            }
            return typeDefinitionBuilder.buildUnionTypeDefinition(unionTypes);
        }
        if (typeDefinitionClass.equals(MultipartTypeDefinition.class)) {
            ArrayList<PartParameter> parts = new ArrayList<PartParameter>();
            for (APIParameterModel apiParameterModel : apiTypeModel.getParts()) {
                PartParameter partParameter = this.parameterBuilder.buildPartParameter(apiParameterModel);
                parts.add(partParameter);
            }
            return typeDefinitionBuilder.buildMultipartTypeDefinition(parts);
        }
        return null;
    }

    public TypeDefinition buildTypeDefinition(String rawSchema, MediaType mediaType) throws ModelGenerationException {
        if (mediaType == null) {
            mediaType = XmlUtils.isXmlSchema(rawSchema) ? MediaType.APPLICATION_XML_TYPE : MediaType.APPLICATION_JSON_TYPE;
        }
        return TypeDefinition.builder(mediaType, this.typeSchemaBuilder.buildTypeSchema(rawSchema), null, null).buildObjectTypeDefinition();
    }

    private PrimitiveTypeDefinition.PrimitiveType buildPrimitiveType(APIPrimitiveTypeModel primitiveTypeModel) {
        return primitiveTypeModel.getPrimitiveType();
    }
}

