/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.type;

import java.util.List;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ArrayTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.MultipartTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ObjectTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.UnionTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.util.HashCodeUtil;

public abstract class TypeDefinition {
    protected MediaType mediaType;
    protected String example;
    protected List<String> enumValues;
    protected TypeSchema typeSchema;

    public TypeDefinition(MediaType mediaType, String example, List<String> enumValues, TypeSchema typeSchema) {
        this.mediaType = mediaType;
        this.example = example;
        this.enumValues = enumValues;
        this.typeSchema = typeSchema;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getExample() {
        return this.example;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public TypeSchema getTypeSchema() {
        return this.typeSchema;
    }

    public boolean isEnum() {
        return this.enumValues != null && !this.enumValues.isEmpty();
    }

    public static TypeDefinition simplePrimitiveType(PrimitiveTypeDefinition.PrimitiveType type) {
        return new PrimitiveTypeDefinition(MediaType.TEXT_PLAIN_TYPE, null, null, null, type);
    }

    public static TypeDefinition simpleStringType() {
        return TypeDefinition.simplePrimitiveType(PrimitiveTypeDefinition.PrimitiveType.STRING);
    }

    public int hashCode() {
        String mediaTypeString = this.mediaType != null ? this.mediaType.toString() : null;
        return HashCodeUtil.generateHashCode(mediaTypeString, this.example, this.enumValues, this.typeSchema);
    }

    public static Builder builder(MediaType mediaType, TypeSchema typeSchema, List<String> enumValues, String example) {
        return new Builder(mediaType, typeSchema, enumValues, example);
    }

    public static class Builder {
        private final MediaType mediaType;
        private final TypeSchema typeSchema;
        private final List<String> enumValues;
        private final String example;

        Builder(MediaType mediaType, TypeSchema typeSchema, List<String> enumValues, String example) {
            this.mediaType = mediaType;
            this.typeSchema = typeSchema;
            this.enumValues = enumValues;
            this.example = example;
        }

        public ArrayTypeDefinition buildArrayType(TypeDefinition innerType) {
            return new ArrayTypeDefinition(this.mediaType, this.example, this.enumValues, this.typeSchema, innerType);
        }

        public MultipartTypeDefinition buildMultipartTypeDefinition(List<PartParameter> parts) {
            return new MultipartTypeDefinition(this.example, this.enumValues, this.typeSchema, parts);
        }

        public ObjectTypeDefinition buildObjectTypeDefinition() {
            return new ObjectTypeDefinition(this.mediaType, this.example, this.enumValues, this.typeSchema);
        }

        public PrimitiveTypeDefinition buildPrimitiveTypeDefinition(PrimitiveTypeDefinition.PrimitiveType primitiveType) {
            return new PrimitiveTypeDefinition(this.mediaType, this.example, this.enumValues, this.typeSchema, primitiveType);
        }

        public UnionTypeDefinition buildUnionTypeDefinition(List<TypeDefinition> unionTypes) {
            return new UnionTypeDefinition(this.mediaType, this.example, this.enumValues, this.typeSchema, unionTypes);
        }

        public EmptyTypeDefinition buildEmptyTypeDefinition() {
            return new EmptyTypeDefinition(this.mediaType, this.example, this.enumValues);
        }
    }
}

