/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.uri;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.MultipleBaseUri;

public class BaseUri {
    private static final String VERSION_URI_PARAM_REGEX = "\\{version\\}";
    private String uri;
    private Type type;
    private String apiVersion;
    private Map<String, MultipleBaseUri> uriMappings = new HashMap<String, MultipleBaseUri>();
    private MultipleBaseUri multipleBaseUriDefault;

    public BaseUri(String uri, String apiVersion) {
        this(uri, Type.PARAMETER, apiVersion);
    }

    public BaseUri(String uri, Type type, String apiVersion) {
        this.uri = uri;
        this.type = type;
        this.apiVersion = apiVersion;
    }

    public String getUri() {
        if (StringUtils.isNotBlank((CharSequence)this.uri)) {
            if (StringUtils.isNotBlank((CharSequence)this.apiVersion)) {
                this.uri = this.uri.replaceAll(VERSION_URI_PARAM_REGEX, this.apiVersion);
            }
            if (this.uri.endsWith("/")) {
                this.uri = this.uri.substring(0, this.uri.length() - 1);
            }
        }
        return this.uri;
    }

    public Type getType() {
        return this.type;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Map<String, MultipleBaseUri> getUriMappings() {
        return this.uriMappings;
    }

    private void addMultipleBaseUri(MultipleBaseUri multipleBaseUri) {
        this.uriMappings.put(multipleBaseUri.getUriId(), multipleBaseUri);
        if (multipleBaseUri.isDefaultUri()) {
            this.multipleBaseUriDefault = multipleBaseUri;
            this.uri = multipleBaseUri.getValue();
        }
    }

    public void addMultipleBaseUri(List<MultipleBaseUri> uris) {
        for (MultipleBaseUri u : uris) {
            this.addMultipleBaseUri(u);
        }
    }

    public MultipleBaseUri getMultipleBaseUriOrDefault(String uriId) {
        return this.uriMappings.getOrDefault(uriId, this.multipleBaseUriDefault);
    }

    public boolean hasMultipleBaseUri() {
        return this.type == Type.MULTIPLE;
    }

    public boolean isParameterizedBaseUri() {
        return this.type == Type.PARAMETER;
    }

    public static enum Type {
        FIXED("fixed", "Fixed base URI specified in the API Spec"),
        PARAMETER("parameter", "Parameter base URI, each instance/tenant gets its own"),
        MULTIPLE("multiple", "Multiple base URI, each operation defines its own base URI");

        private static final Map<String, Type> BY_TYPE;
        private String name;
        private String description;

        private Type(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public static Type valueOfName(String name) {
            return BY_TYPE.get(name.toLowerCase());
        }

        static {
            BY_TYPE = new HashMap<String, Type>();
            for (Type e : Type.values()) {
                BY_TYPE.put(e.getName(), e);
            }
        }
    }
}

