/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorOperationParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

class DescriptorEndpointParser {
    private static final String API_CONTRACT_ENDPOINT = "http://a.ml/vocabularies/apiContract#endpoint";
    private static final String API_CONTRACT_PATH = "http://a.ml/vocabularies/apiContract#path";
    private DescriptorOperationParser descriptorOperationParser = new DescriptorOperationParser();

    DescriptorEndpointParser() {
    }

    public List<EndPointDescriptor> parseEndpoints(DialectDomainElement encodes, Path descriptorFilePath) throws ModelGenerationException {
        ArrayList<EndPointDescriptor> endpointDescriptors = new ArrayList<EndPointDescriptor>();
        for (DialectDomainElement x : this.getEndpoints(encodes)) {
            endpointDescriptors.add(this.parseEndpoint(x, descriptorFilePath));
        }
        return endpointDescriptors;
    }

    private EndPointDescriptor parseEndpoint(DialectDomainElement endpointElement, Path descriptorFilePath) throws ModelGenerationException {
        return new EndPointDescriptor(this.getEndpointPath(endpointElement), this.descriptorOperationParser.parseOperations(endpointElement, descriptorFilePath), DescriptorParserUtils.parseRestConnectIgnored(endpointElement), DescriptorParserUtils.parseAlternativeBaseUri(endpointElement));
    }

    private List<DialectDomainElement> getEndpoints(DialectDomainElement encodes) {
        return encodes.getObjectPropertyUri(API_CONTRACT_ENDPOINT);
    }

    private String getEndpointPath(DialectDomainElement endpointElement) {
        return APIOperationModel.buildStandardPath(endpointElement.getScalarByPropertyUri(API_CONTRACT_PATH).get(0).toString());
    }
}

