/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorRequestParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorSkipOutputTypeValidationParser;

public class DescriptorOperationParser {
    private static final String API_CONTRACT_SUPPORTED_OPERATION = "http://a.ml/vocabularies/apiContract#supportedOperation";
    private static final String API_CONTRACT_METHOD = "http://a.ml/vocabularies/apiContract#method";
    private static final String REST_CONNECT_OPERATION_NAME = "http://a.ml/vocabularies/restConnect#operationName";
    private static final String REST_CONNECT_OPERATION_DESCRIPTION = "http://a.ml/vocabularies/restConnect#operationDescription";
    private static final String REST_CONNECT_DEFAULT_INPUT_MEDIA_TYPE = "http://a.ml/vocabularies/restConnect#inputMediaType";
    private static final String REST_CONNECT_DEFAULT_OUTPUT_MEDIA_TYPE = "http://a.ml/vocabularies/restConnect#outputMediaType";
    private static final String REST_CONNECT_INPUT_TYPE = "http://a.ml/vocabularies/restConnect#inputType";
    private static final String REST_CONNECT_OUTPUT_TYPE = "http://a.ml/vocabularies/restConnect#outputType";
    private static final String REST_CONNECT_PAGINATION = "http://a.ml/vocabularies/restConnect#paginationReference";
    private DescriptorRequestParser descriptorRequestParser = new DescriptorRequestParser();
    private DescriptorSkipOutputTypeValidationParser descriptorSkipOutputTypeValidationParser = new DescriptorSkipOutputTypeValidationParser();

    public List<OperationDescriptor> parseOperations(DialectDomainElement endpointElement, Path descriptorFilePath) throws ModelGenerationException {
        ArrayList<OperationDescriptor> operationDescriptors = new ArrayList<OperationDescriptor>();
        for (DialectDomainElement x : this.getSupportedOperations(endpointElement)) {
            operationDescriptors.add(this.parseOperation(x, descriptorFilePath));
        }
        return operationDescriptors;
    }

    private OperationDescriptor parseOperation(DialectDomainElement operationElement, Path descriptorFilePath) throws ModelGenerationException {
        Path descriptorDirectory = descriptorFilePath.getParent();
        return new OperationDescriptor(this.getMethod(operationElement), this.getName(operationElement), this.getDescription(operationElement), this.getDefaultInputMediaType(operationElement), this.getDefaultOutputMediaType(operationElement), this.descriptorRequestParser.parseRequest(operationElement), DescriptorParserUtils.parseRestConnectIgnored(operationElement), DescriptorParserUtils.parseAlternativeBaseUri(operationElement), this.getPagination(operationElement), this.parseSkipOutputTypeValidation(operationElement), this.getInputTypeSchema(operationElement, descriptorDirectory), this.getOutputTypeSchema(operationElement, descriptorDirectory));
    }

    private List<DialectDomainElement> getSupportedOperations(DialectDomainElement endpointElement) {
        return endpointElement.getObjectPropertyUri(API_CONTRACT_SUPPORTED_OPERATION);
    }

    private Boolean parseSkipOutputTypeValidation(DialectDomainElement operationElement) {
        return this.descriptorSkipOutputTypeValidationParser.parseSkipOutputTypeValidation(operationElement);
    }

    public String getMethod(DialectDomainElement operationElement) {
        return operationElement.getScalarByPropertyUri(API_CONTRACT_METHOD).get(0).toString();
    }

    private String getDescription(DialectDomainElement operationElement) {
        List apiOperationDescription = operationElement.getScalarByPropertyUri(REST_CONNECT_OPERATION_DESCRIPTION);
        return apiOperationDescription.isEmpty() ? null : apiOperationDescription.get(0).toString();
    }

    private String getName(DialectDomainElement operationElement) {
        List operationNamesMetadata = operationElement.getScalarByPropertyUri(REST_CONNECT_OPERATION_NAME);
        return operationNamesMetadata.isEmpty() ? null : operationNamesMetadata.get(0).toString();
    }

    private String getDefaultInputMediaType(DialectDomainElement operationElement) {
        List operationNamesMetadata = operationElement.getScalarByPropertyUri(REST_CONNECT_DEFAULT_INPUT_MEDIA_TYPE);
        return operationNamesMetadata.isEmpty() ? null : operationNamesMetadata.get(0).toString();
    }

    private String getInputTypeSchema(DialectDomainElement operationElement, Path descriptorDirectory) throws ModelGenerationException {
        List operationNamesMetadata = operationElement.getScalarByPropertyUri(REST_CONNECT_INPUT_TYPE);
        String inputSchemaPathString = operationNamesMetadata.isEmpty() ? null : operationNamesMetadata.get(0).toString();
        return this.getSchemaContent(descriptorDirectory, inputSchemaPathString);
    }

    private String getOutputTypeSchema(DialectDomainElement operationElement, Path descriptorDirectory) throws ModelGenerationException {
        List operationNamesMetadata = operationElement.getScalarByPropertyUri(REST_CONNECT_OUTPUT_TYPE);
        String inputSchemaPathString = operationNamesMetadata.isEmpty() ? null : operationNamesMetadata.get(0).toString();
        return this.getSchemaContent(descriptorDirectory, inputSchemaPathString);
    }

    private String getSchemaContent(Path descriptorDirectory, String inputSchemaPathString) throws ModelGenerationException {
        if (StringUtils.isBlank((CharSequence)inputSchemaPathString)) {
            return null;
        }
        Path schemaPath = descriptorDirectory.resolve(inputSchemaPathString);
        try {
            byte[] encoded = Files.readAllBytes(schemaPath);
            return new String(encoded, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ModelGenerationException("Could not read schema file: " + schemaPath, e);
        }
    }

    private String getDefaultOutputMediaType(DialectDomainElement operationElement) {
        List operationNamesMetadata = operationElement.getScalarByPropertyUri(REST_CONNECT_DEFAULT_OUTPUT_MEDIA_TYPE);
        return operationNamesMetadata.isEmpty() ? null : operationNamesMetadata.get(0).toString();
    }

    private String getPagination(DialectDomainElement operationElement) {
        List paginationName = operationElement.getScalarByPropertyUri(REST_CONNECT_PAGINATION);
        return paginationName.isEmpty() ? null : paginationName.get(0).toString();
    }
}

