/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.document.DialectInstance;
import amf.client.model.domain.DialectDomainElement;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PaginationDeclarationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.SecuritySchemeDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorApiSpecParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorBaseUriParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorConnectorCategoryParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorCustomJavaPackageParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorEndpointParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorExtensionXmlParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorMavenGavParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorPaginationParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorSkipOutputTypeValidationParser;
import org.mule.connectivity.restconnect.internal.util.AMFWrapper;

public final class DescriptorParser {
    private DescriptorBaseUriParser descriptorBaseUriParser = new DescriptorBaseUriParser();
    private DescriptorEndpointParser descriptorEndpointParser = new DescriptorEndpointParser();
    private DescriptorApiSpecParser descriptorApiSpecParser = new DescriptorApiSpecParser();
    private DescriptorMavenGavParser descriptorMavenGavParser = new DescriptorMavenGavParser();
    private DescriptorCustomJavaPackageParser descriptorCustomJavaPackageParser = new DescriptorCustomJavaPackageParser();
    private DescriptorConnectorCategoryParser descriptorConnectorCategoryParser = new DescriptorConnectorCategoryParser();
    private DescriptorExtensionXmlParser descriptorExtensionXmlParser = new DescriptorExtensionXmlParser();
    private DescriptorSkipOutputTypeValidationParser descriptorSkipOutputTypeValidationParser = new DescriptorSkipOutputTypeValidationParser();

    public ConnectorDescriptor parseConnectorDescriptor(File connectorDescriptor) throws ModelGenerationException {
        DialectInstance dialectInstance = AMFWrapper.parseConnectorDescriptor(connectorDescriptor);
        DialectDomainElement encodes = dialectInstance.encodes();
        return new ConnectorDescriptor(this.descriptorApiSpecParser.parseApiSpec(encodes), this.parseConnectorName(encodes), this.parseConnectorDescription(encodes), this.descriptorMavenGavParser.parseMavenGav(this.descriptorMavenGavParser.parseConnectorGavElement(encodes)), this.descriptorBaseUriParser.parseBaseUri(encodes), this.descriptorEndpointParser.parseEndpoints(encodes, connectorDescriptor.toPath()), DescriptorParser.parsePaginations(encodes), this.parseSecurity(), this.parseConnectorCategory(encodes), this.parseCustomJavaPackage(encodes), this.parseExtensionXml(encodes), this.parseSkipOutputTypeValidation(encodes));
    }

    private Boolean parseSkipOutputTypeValidation(DialectDomainElement encodes) {
        return this.descriptorSkipOutputTypeValidationParser.parseSkipOutputTypeValidation(encodes);
    }

    private String parseExtensionXml(DialectDomainElement encodes) {
        return this.descriptorExtensionXmlParser.parseExtensionXml(encodes);
    }

    private String parseCustomJavaPackage(DialectDomainElement encodes) {
        return this.descriptorCustomJavaPackageParser.parseJavaPackage(encodes);
    }

    private String parseConnectorCategory(DialectDomainElement encodes) {
        return this.descriptorConnectorCategoryParser.parseConnectorCategory(encodes);
    }

    private List<SecuritySchemeDescriptor> parseSecurity() {
        return Collections.emptyList();
    }

    private static List<PaginationDeclarationDescriptor> parsePaginations(DialectDomainElement encodes) {
        return DescriptorPaginationParser.parsePaginationsDescription(encodes);
    }

    private String parseConnectorDescription(DialectDomainElement encodes) {
        return DescriptorParserUtils.parseElementCoreDescription(encodes);
    }

    private String parseConnectorName(DialectDomainElement encodes) {
        return DescriptorParserUtils.parseElementCoreName(encodes);
    }
}

