/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.function.Function;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.InPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.OutPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.Pagination;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.PaginationParameter;
import org.mule.connectivity.restconnect.internal.templating.sdk.AbstractSdkOperation;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkPaginationStratety;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkPagingTypeResolver;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public abstract class AbstractSdkPaginationOperation
extends AbstractSdkOperation
implements SdkPaginationStratety {
    public static final String PAGING_RESPONSE_EXPRESSION = "pagingResponseExpression";
    private final Pagination pagination;
    private final SdkPagingTypeResolver pagingTypeResolver;

    public abstract String getInitialPagingParameterSummary();

    public AbstractSdkPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) {
        super(outputDir, connectorModel, sdkConnector, operation);
        this.pagination = connectorModel.getPagination(operation.getPagination());
        this.pagingTypeResolver = new SdkPagingTypeResolver(outputDir, connectorModel, operation, operation.getOutputMetadata(), this.sdkOutputMetadata);
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public AnnotationSpec buildSummaryAnnotation() {
        return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText(this.getInitialPagingParameterSummary())}).build();
    }

    public AnnotationSpec buildDefaultAnnotation() {
        return AnnotationSpec.builder(Optional.class).addMember("defaultValue", "$S", new Object[]{this.getInitialValue()}).build();
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.content != null) {
            this.content.applyTemplates();
        }
        this.pagingTypeResolver.applyTemplates();
        this.generateOperationClass();
    }

    @Override
    public ParameterSpec generateInitialPagingParameter() {
        return ParameterSpec.builder((TypeName)TypeName.INT, (String)this.getInitialParamName(), (Modifier[])new Modifier[0]).addAnnotation(this.buildDefaultAnnotation()).addAnnotation(this.buildSummaryAnnotation()).build();
    }

    @Override
    public CodeBlock getPagingMethodOperation() {
        CodeBlock.Builder paginationBody = CodeBlock.builder();
        paginationBody.addStatement("return new $T($S, $L, requestFactory, expressionLanguage, streamingHelper, $S, org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON, config.getEncoding(), overrides.getResponseTimeoutAsMillis())", new Object[]{this.getPagingProvider(), this.getTokenParamName(), this.generateInitialPagingParameter().name, this.getPayloadExpression()});
        return paginationBody.build();
    }

    @Override
    public TypeName generateMethodReturn() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(PagingProvider.class), (TypeName[])new TypeName[]{TypeName.get(RestConnection.class), ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{String.class})});
    }

    @Override
    public CodeBlock generateOperationMethodBody() {
        CodeBlock.Builder paginationBody = CodeBlock.builder();
        CodeBlock.Builder methodBody = super.generateCommonOperationMethodBody();
        methodBody.addStatement("return builder", new Object[0]);
        paginationBody.addStatement("$T<$T,$T> requestFactory = connection -> { $L } ", new Object[]{Function.class, RestConnection.class, HttpRequestBuilder.class, methodBody.build().toString()});
        paginationBody.add(this.getPagingMethodOperation());
        return paginationBody.build();
    }

    @Override
    protected void addOutputTypeAnnotationToMethod(MethodSpec.Builder methodBuilder) {
        if (this.pagingTypeResolver.getRequiresTypeResolver()) {
            AnnotationSpec outputAnnotation = AnnotationSpec.builder(OutputResolver.class).addMember("output", "$T.class", new Object[]{ClassName.get((String)this.pagingTypeResolver.getPackage(), (String)this.pagingTypeResolver.getClassName(), (String[])new String[0])}).build();
            methodBuilder.addAnnotation(outputAnnotation);
        }
    }

    @Override
    public FieldSpec generateExpressionLanguageField() {
        return FieldSpec.builder(ExpressionLanguage.class, (String)"expressionLanguage", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(Inject.class).build()).build();
    }

    @Override
    public String getInitialValue() {
        PaginationParameter parameter = this.getPagination().getParameter(this.getInitialParamName());
        if (parameter == null) {
            return "0";
        }
        return parameter instanceof InPaginationParameter ? ((InPaginationParameter)parameter).getValueExtraction().getContent() : ((OutPaginationParameter)parameter).getValue();
    }

    @Override
    public String getPayloadExpression() {
        PaginationParameter parameter = this.pagination.getParameter(PAGING_RESPONSE_EXPRESSION);
        return parameter == null ? null : ((InPaginationParameter)parameter).getValueExtraction().getContent();
    }

    @Override
    protected boolean requiresConnectionParameter() {
        return false;
    }

    @Override
    protected boolean requiresCallbackParameter() {
        return false;
    }

    @Override
    protected boolean requiresConfigParameter() {
        return true;
    }

    @Override
    protected boolean requiresMediaTypeAnnotation() {
        return false;
    }
}

