/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkTypeDefinition;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.util.NameUtils;

public class SdkParameter
extends JavaTemplateEntity {
    private final Parameter parameter;
    private final SdkTypeDefinition sdkTypeDefinition;

    public SdkParameter(Path outputDir, ConnectorModel connectorModel, Parameter parameter) {
        super(outputDir, connectorModel);
        this.parameter = parameter;
        this.sdkTypeDefinition = new SdkTypeDefinition(parameter.getTypeDefinition());
    }

    public String getExternalName() {
        return this.parameter.getExternalName();
    }

    public String getJavaName() {
        String javaName = JavaUtils.getJavaLowerCamelNameFromXml(this.parameter.getInternalName());
        if (this.isArrayType()) {
            javaName = NameUtils.pluralize((String)javaName);
        }
        if (JavaUtils.isReservedJavaWord(javaName)) {
            return "j" + javaName;
        }
        return javaName;
    }

    public String getDisplayName() {
        return this.parameter.getDisplayName();
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public boolean isArrayType() {
        return this.sdkTypeDefinition.isArrayType();
    }

    private TypeName getTypeName() {
        return this.sdkTypeDefinition.getParameterTypeName();
    }

    @Override
    public void applyTemplates() {
    }

    public ParameterSpec.Builder generateParameterParameter() {
        AnnotationSpec nullSafeAnnotation;
        ParameterSpec.Builder paramSpecBuilder = ParameterSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]);
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            paramSpecBuilder.addAnnotation(optionalAnnotation);
        }
        if ((nullSafeAnnotation = this.getNullSafeAnnotation()) != null) {
            paramSpecBuilder.addAnnotation(nullSafeAnnotation);
        }
        paramSpecBuilder.addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec summaryAnnotation = this.getSummaryAnnotation();
        if (summaryAnnotation != null) {
            paramSpecBuilder.addAnnotation(summaryAnnotation);
        }
        return paramSpecBuilder;
    }

    public FieldSpec.Builder generateParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(org.mule.runtime.extension.api.annotation.param.Parameter.class).build();
        return this.generateParameterField(parameterAnnotation);
    }

    public FieldSpec.Builder generateOAuthParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(OAuthParameter.class).addMember("requestAlias", "$S", new Object[]{this.parameter.getExternalName()}).build();
        return this.generateParameterField(parameterAnnotation);
    }

    private FieldSpec.Builder generateParameterField(AnnotationSpec parameterAnnotation) {
        AnnotationSpec summaryAnnotation;
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]).addAnnotation(parameterAnnotation).addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            fieldSpecBuilder.addAnnotation(optionalAnnotation);
        }
        if ((summaryAnnotation = this.getSummaryAnnotation()) != null) {
            fieldSpecBuilder.addAnnotation(summaryAnnotation);
        }
        return fieldSpecBuilder;
    }

    private AnnotationSpec getNullSafeAnnotation() {
        if (!this.parameter.isRequired() && this.isArrayType()) {
            return AnnotationSpec.builder(NullSafe.class).build();
        }
        return null;
    }

    private AnnotationSpec getOptionalAnnotation() {
        if (!this.parameter.isRequired() || StringUtils.isNotBlank((CharSequence)this.parameter.getDefaultValue())) {
            AnnotationSpec.Builder optionalBuilder = AnnotationSpec.builder(Optional.class);
            if (StringUtils.isNotBlank((CharSequence)this.parameter.getDefaultValue())) {
                optionalBuilder.addMember("defaultValue", "$S", new Object[]{this.parameter.getDefaultValue()});
            }
            return optionalBuilder.build();
        }
        return null;
    }

    private AnnotationSpec getDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.parameter.getDisplayName()}).build();
    }

    private AnnotationSpec getSummaryAnnotation() {
        if (StringUtils.isNotBlank((CharSequence)this.parameter.getDescription())) {
            return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText(this.parameter.getDescription())}).build();
        }
        return null;
    }

    public boolean isNullable() {
        return !this.sdkTypeDefinition.getParameterPrimitiveJavaType().equals(Boolean.TYPE);
    }

    public String getStringValueGetter() {
        return this.getStringValueGetter(this.getJavaName());
    }

    public String getStringValueGetter(String varName) {
        if (this.sdkTypeDefinition.getJavaType().equals(String.class)) {
            return varName;
        }
        return "String.valueOf(" + varName + ")";
    }
}

