/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.util;

import amf.MessageStyle;
import amf.ProfileName;
import amf.client.AMF;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.DialectInstance;
import amf.client.parse.Aml10Parser;
import amf.client.resolve.Resolver;
import amf.client.validate.ValidationReport;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import javax.validation.constraints.NotNull;
import metadata.RestConnectMetadataHandler;
import org.apache.commons.io.FileUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;

public final class AMFWrapper {
    private static final Semaphore initializationSemaphore = new Semaphore(1);
    private static boolean amfInitialized = false;
    private static final String REST_CONNECT_DIALECT = "/metadata/dialects/rest_connect_dialect.yaml";
    private static final String REST_CONNECT_VOCABULARY = "/metadata/vocabularies/rest_connect_vocabulary.yaml";

    private AMFWrapper() {
    }

    public static void initialize() throws ModelGenerationException {
        if (!amfInitialized) {
            try {
                initializationSemaphore.acquire();
                if (!amfInitialized) {
                    AMF.init().get();
                    AMFWrapper.registerDialect();
                }
            }
            catch (ExecutionException e) {
                throw new ModelGenerationException("Error initializing AMF.", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ModelGenerationException("Error initializing AMF.", e);
            }
            finally {
                initializationSemaphore.release();
            }
            amfInitialized = true;
        }
    }

    private static void registerDialect() throws ModelGenerationException {
        try {
            InputStream source = RestConnectMetadataHandler.class.getResourceAsStream(REST_CONNECT_DIALECT);
            InputStream vocabulary = RestConnectMetadataHandler.class.getResourceAsStream(REST_CONNECT_VOCABULARY);
            File baseTmpDir = Files.createTempDir();
            File baseDir = new File(baseTmpDir.toPath() + "/dialects");
            File baseDirVoc = new File(baseTmpDir.toPath() + "/vocabularies");
            File tmpDialect = new File(baseDir, "rest_connect_dialect.yaml");
            File tempVocabulary = new File(baseDirVoc, "rest_connect_vocabulary.yaml");
            FileUtils.copyInputStreamToFile((InputStream)vocabulary, (File)tempVocabulary);
            FileUtils.copyInputStreamToFile((InputStream)source, (File)tmpDialect);
            URI uri = tmpDialect.toURI();
            AMF.registerDialect((String)uri.toURL().toString()).get();
        }
        catch (IOException | ExecutionException e) {
            throw new ModelGenerationException("Could register Rest Connect Dialect.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModelGenerationException("Could register Rest Connect Dialect.", e);
        }
    }

    public static DialectInstance parseConnectorDescriptor(@NotNull File connectorDescriptor) throws ModelGenerationException {
        DialectInstance dialectInstance;
        AMFWrapper.initialize();
        try {
            dialectInstance = (DialectInstance)new Aml10Parser().parseFileAsync(connectorDescriptor.toURI().toURL().toString()).get();
        }
        catch (MalformedURLException | ExecutionException e) {
            throw new ModelGenerationException("Could not parse connector descriptor.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModelGenerationException("Could not parse connector descriptor.", e);
        }
        dialectInstance = (DialectInstance)new Resolver("AML 1.0").resolve((BaseUnit)dialectInstance);
        AMFWrapper.validate(dialectInstance);
        return Objects.requireNonNull(dialectInstance);
    }

    public static void validate(DialectInstance metadata) throws ModelGenerationException {
        ValidationReport report;
        try {
            report = (ValidationReport)AMF.validate((BaseUnit)metadata, (ProfileName)ProfileName.apply((String)"Rest Connect Connector Descriptor 1.0"), (MessageStyle)MessageStyle.apply((String)"AMF")).get();
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            throw new ModelGenerationException("Could not validate connector descriptor", e);
        }
        if (!report.conforms()) {
            throw new ModelGenerationException(report.toString());
        }
    }
}

