/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.webapi.util.ParserUtils;

public final class NamingUtil {
    private static Pattern dashSeparationPattern = Pattern.compile("([a-zA-Z0-9])([\\-\\_]+)([a-zA-Z0-9]*)");

    private NamingUtil() {
    }

    public static boolean isFriendlyName(String name) {
        if (name.contains(" ")) {
            return true;
        }
        return ParserUtils.splitCaps(name, " ").equalsIgnoreCase(name) && !dashSeparationPattern.matcher(name).find();
    }

    public static String makeNameFriendly(String name) {
        String friendlyName = name.trim();
        if (friendlyName.contains(" ")) {
            return friendlyName;
        }
        while (dashSeparationPattern.matcher(friendlyName).find()) {
            friendlyName = dashSeparationPattern.matcher(friendlyName).replaceAll("$1 $3");
        }
        if ((friendlyName = ParserUtils.splitCaps(friendlyName, " ")).toUpperCase().equals(friendlyName)) {
            friendlyName = friendlyName.toLowerCase();
        }
        return StringUtils.capitalize((String)friendlyName);
    }
}

