/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

public class R001Validator
implements RuleValidator {
    @Override
    public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        List descriptorPaths = connectorDescriptor.getEndpoints().stream().map(EndPointDescriptor::getPath).collect(Collectors.toList());
        List apiPaths = apiModel.getOperationsModel().stream().map(APIOperationModel::getPath).distinct().collect(Collectors.toList());
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (String descriptorPath : descriptorPaths) {
            if (!apiPaths.stream().noneMatch(x -> x.equalsIgnoreCase(descriptorPath))) continue;
            validationResults.add(new ValidationResult(ModelValidationRules.R001, "Path: " + descriptorPath));
        }
        return validationResults;
    }
}

