/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.HTTPMethod;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;

public class R003Validator
implements RuleValidator {
    @Override
    public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        List nullOutputAPIOperations = apiModel.getOperationsModel().stream().filter(x -> this.httpMethodApplies(x.getHttpMethod())).filter(this::hasNoTypeDefinition).collect(Collectors.toList());
        return nullOutputAPIOperations.stream().filter(nullOutputOperation -> !this.validationSkipped(connectorModel, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.typeDefinedInDescriptor(connectorDescriptor, (APIOperationModel)nullOutputOperation)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean hasNoTypeDefinition(APIOperationModel apiOperationModel) {
        if (apiOperationModel.getOutputMetadataModel().isEmpty()) {
            return true;
        }
        boolean noOutputTypeDefinition = true;
        for (APITypeModel outputType : apiOperationModel.getOutputMetadataModel()) {
            if (outputType.getMediaType().equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
                noOutputTypeDefinition = false;
                continue;
            }
            if (outputType.getTypeDefinitionClass() == null || outputType.getTypeDefinitionClass() == EmptyTypeDefinition.class || outputType.getAPITypeSchemaModel().getTypeSchema() == null || !StringUtils.isNotBlank((CharSequence)outputType.getAPITypeSchemaModel().getTypeSchema().getRawSchema())) continue;
            noOutputTypeDefinition = false;
        }
        return noOutputTypeDefinition;
    }

    private boolean httpMethodApplies(HTTPMethod httpMethod) {
        return httpMethod.equals((Object)HTTPMethod.GET) || httpMethod.equals((Object)HTTPMethod.POST) || httpMethod.equals((Object)HTTPMethod.PATCH) || httpMethod.equals((Object)HTTPMethod.OPTIONS);
    }

    private boolean validationSkipped(ConnectorModel connectorModel, APIOperationModel apiOperationModel) {
        boolean globalSkip = connectorModel.getSkipOutputTypeValidation() != null && connectorModel.getSkipOutputTypeValidation() != false;
        ConnectorOperation connectorOperation = connectorModel.getOperations().stream().filter(x -> x.getHttpMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).findFirst().orElse(null);
        if (connectorOperation == null) {
            return false;
        }
        if (connectorOperation.getSkipOutputTypeValidation() == null) {
            return globalSkip;
        }
        return connectorOperation.getSkipOutputTypeValidation();
    }

    private boolean typeDefinedInDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema());
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();
        return new ValidationResult(ModelValidationRules.R003, location);
    }
}

