/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class R007Validator
implements RuleValidator {
    @Override
    public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String groupId = connectorDescriptor.getConnectorGav().getGroupId();
        String validGroupId = XmlUtils.removeMavenGroupUnwantedCharacters(groupId);
        String validJavaPackageGroupId = JavaUtils.removeJavaPackageUnwantedCharacters(groupId);
        if (!groupId.equalsIgnoreCase(validGroupId) || !groupId.equalsIgnoreCase(validJavaPackageGroupId)) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(ModelValidationRules.R007, "'groupId' property declared in the connector descriptor's 'connectorGav' property");
    }
}

