/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.security.NotSupportedScheme;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

public class R010Validator
implements RuleValidator {
    @Override
    public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        return apiModel.getOperationsModel().stream().filter(this::anySecuritySchemeNotSupported).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean anySecuritySchemeNotSupported(APIOperationModel apiOperationModel) {
        return !apiOperationModel.getSecuritySchemesModel().isEmpty() && apiOperationModel.getSecuritySchemesModel().stream().anyMatch(x -> x.getSecuritySchemeClass().equals(NotSupportedScheme.class));
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();
        return new ValidationResult(ModelValidationRules.R010, location);
    }
}

