/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.ParameterDescriptor;
import org.mule.connectivity.restconnect.internal.util.NamingUtil;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

public class R013Validator
implements RuleValidator {
    @Override
    public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        LinkedList<ValidationResult> results = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endpointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endpointDescriptor.getOperations()) {
                if (operationDescriptor.getExpects() == null) continue;
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getUriParameter(), ParameterType.URI, operationDescriptor, endpointDescriptor));
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getQueryParameter(), ParameterType.QUERY, operationDescriptor, endpointDescriptor));
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getHeader(), ParameterType.HEADER, operationDescriptor, endpointDescriptor));
            }
        }
        return results;
    }

    List<ValidationResult> validateParameterNames(List<ParameterDescriptor> parameters, ParameterType parameterType, OperationDescriptor operationDescriptor, EndPointDescriptor endpointDescriptor) {
        return parameters.stream().filter(x -> !NamingUtil.isFriendlyName(x.getFriendlyName())).map(x -> this.getValidationError(endpointDescriptor, operationDescriptor, (ParameterDescriptor)x, parameterType)).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor, ParameterDescriptor parameterDescriptor, ParameterType parameterType) {
        String location = "Operation Descriptor with PATH: " + endpointDescriptor.getPath() + " and METHOD: " + operationDescriptor.getMethod() + " declares a " + parameterType.getName() + " named " + parameterDescriptor.getFriendlyName() + " whose display name is : " + parameterDescriptor.getFriendlyName();
        return new ValidationResult(ModelValidationRules.R013, location);
    }
}

