/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.ModelValidationRules;
import org.mule.connectivity.restconnect.internal.validation.RuleValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

public class R014Validator
implements RuleValidator {
    @Override
    public List<ValidationResult> validate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getInputMetadataModel().size() > 1).filter(x -> !this.operationHasDefaultInputType(connectorDescriptor, (APIOperationModel)x)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean operationHasDefaultInputType(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).anyMatch(x -> StringUtils.isNotBlank((CharSequence)x.getInputMediaType()));
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + (Object)((Object)apiOperationModel.getHttpMethod());
        return new ValidationResult(ModelValidationRules.R014, location);
    }
}

