/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.model;

import java.io.File;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.connectormodel.Protocol;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

public abstract class APIModel {
    private final File apiSpec;
    private final String rootDir;
    protected String apiName = "";
    protected String description = "";
    protected BaseUri baseUri;
    protected List<APIOperationModel> operationsModel = new LinkedList<APIOperationModel>();
    protected List<Protocol> protocols;

    public APIModel(File apiSpec, String rootDir) {
        this.apiSpec = apiSpec;
        this.rootDir = rootDir;
    }

    public Path getRootDir() {
        return this.rootDir != null ? new File(this.rootDir).toPath().toAbsolutePath() : this.apiSpec.getParentFile().toPath();
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getDescription() {
        return this.description;
    }

    public BaseUri getBaseUri() {
        return this.baseUri;
    }

    public List<APIOperationModel> getOperationsModel() {
        return this.operationsModel;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }
}

