/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import amf.MessageStyle;
import amf.ProfileName;
import amf.ProfileNames;
import amf.client.AMF;
import amf.client.environment.DefaultEnvironment;
import amf.client.environment.Environment;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Server;
import amf.client.model.domain.WebApi;
import amf.client.parse.Oas20Parser;
import amf.client.parse.Oas20YamlParser;
import amf.client.parse.Parser;
import amf.client.parse.Raml10Parser;
import amf.client.resource.ResourceLoader;
import amf.client.validate.ValidationReport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.Protocol;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.util.AMFWrapper;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.resourceloader.AMFExchangeDependencyResourceLoader;

public class AMFAPIModel
extends APIModel {
    private final SpecFormat specFormat;
    private final WebApi webApi;

    public AMFAPIModel(File apiSpec, String rootDir, SpecFormat specFormat) throws ModelGenerationException {
        super(apiSpec, rootDir);
        AMFWrapper.initialize();
        this.specFormat = specFormat;
        this.webApi = this.getWebApi(this.getParser(specFormat, rootDir), apiSpec.toPath());
        this.apiName = this.buildApiName();
        this.description = this.buildDescription();
        this.baseUri = this.buildBaseUri();
        this.operationsModel = this.buildOperationsModel();
        this.protocols = this.buildProtocols();
    }

    private String buildApiName() {
        return this.webApi.name().value();
    }

    private String buildDescription() {
        return this.webApi.description().nonEmpty() ? this.webApi.description().value() : "";
    }

    private BaseUri buildBaseUri() {
        String apiVersion = this.webApi.version() != null ? this.webApi.version().value() : null;
        String baseUri = null;
        Server server = this.webApi.servers().stream().filter(x -> x.url().nonEmpty()).findFirst().orElse(null);
        if (server != null) {
            baseUri = server.url().value();
        }
        return new BaseUri(baseUri, apiVersion);
    }

    private List<Protocol> buildProtocols() {
        return this.webApi.schemes().stream().map(x -> Protocol.getFromString(x.value())).collect(Collectors.toList());
    }

    private List<APIOperationModel> buildOperationsModel() throws ModelGenerationException {
        ArrayList<APIOperationModel> operationsModel = new ArrayList<APIOperationModel>();
        for (EndPoint endPoint : this.webApi.endPoints()) {
            for (Operation operation : endPoint.operations()) {
                operationsModel.add(new AMFOperationModel(endPoint, operation));
            }
        }
        return operationsModel;
    }

    private Parser getParser(SpecFormat format, String rootDir) {
        Environment env = DefaultEnvironment.apply().add((ResourceLoader)new AMFExchangeDependencyResourceLoader(rootDir));
        if (format.equals((Object)SpecFormat.RAML)) {
            return new Raml10Parser(env);
        }
        if (format.equals((Object)SpecFormat.JSON_OAS)) {
            return new Oas20Parser(env);
        }
        if (format.equals((Object)SpecFormat.YAML_OAS)) {
            return new Oas20YamlParser(env);
        }
        throw new IllegalArgumentException("Spec format " + format.getName() + " not supported");
    }

    private WebApi getWebApi(Parser parser, Path path) throws InvalidSourceException {
        Document ramlDocument;
        if (this.isRaml08(path.toAbsolutePath())) {
            throw new InvalidSourceException("RAML 0.8 is not supported.");
        }
        try {
            ramlDocument = this.parseFile(parser, "file://" + path.toAbsolutePath().toString());
            this.validate(ramlDocument, this.specFormat);
            ramlDocument = this.resolve(ramlDocument, this.specFormat);
        }
        catch (Exception e) {
            throw new InvalidSourceException("Invalid Spec: Error in AMF: " + e.getMessage() + ".", e);
        }
        return this.getWebApi(ramlDocument);
    }

    private Document resolve(Document ramlDocument, SpecFormat specFormat) {
        if (specFormat.equals((Object)SpecFormat.RAML)) {
            return (Document)AMF.resolveRaml10((BaseUnit)ramlDocument);
        }
        if (specFormat.equals((Object)SpecFormat.JSON_OAS) || specFormat.equals((Object)SpecFormat.YAML_OAS)) {
            return (Document)AMF.resolveOas20((BaseUnit)ramlDocument);
        }
        throw new IllegalArgumentException("Unrecognised spec format");
    }

    private void validate(Document ramlDocument, SpecFormat specFormat) throws ExecutionException, InterruptedException, InvalidSourceException {
        if (specFormat.equals((Object)SpecFormat.RAML)) {
            ValidationReport report = (ValidationReport)AMF.validate((BaseUnit)ramlDocument, (ProfileName)ProfileNames.RAML(), (MessageStyle)ProfileNames.AMF().messageStyle()).get();
            if (!report.conforms()) {
                throw new InvalidSourceException(report.toString());
            }
        } else if (specFormat.equals((Object)SpecFormat.JSON_OAS) || specFormat.equals((Object)SpecFormat.YAML_OAS)) {
            ValidationReport report = (ValidationReport)AMF.validate((BaseUnit)ramlDocument, (ProfileName)ProfileNames.OAS(), (MessageStyle)ProfileNames.AMF().messageStyle()).get();
            if (!report.conforms()) {
                throw new InvalidSourceException(report.toString());
            }
        } else {
            throw new IllegalArgumentException("Unrecognised spec format");
        }
    }

    private WebApi getWebApi(Document document) {
        return (WebApi)document.encodes();
    }

    private Document parseFile(Parser parser, String url) {
        return this.handleFuture(parser.parseFileAsync(url));
    }

    private Document handleFuture(CompletableFuture<BaseUnit> f) {
        try {
            return (Document)f.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("An error occurred while parsing the api. Message: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("An error occurred while parsing the api. Message: " + e.getMessage(), e);
        }
    }

    private boolean isRaml08(Path specPath) throws InvalidSourceException {
        String content;
        try {
            content = new String(Files.readAllBytes(specPath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new InvalidSourceException("Could not load raml file content", e);
        }
        return content.startsWith("#%RAML 0.8");
    }
}

