/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.DomainElement;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.ParametrizedSecurityScheme;
import amf.client.model.domain.Payload;
import amf.client.model.domain.Response;
import amf.client.model.domain.SecurityScheme;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.connectormodel.HTTPMethod;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APISecuritySchemeModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFSecuritySchemeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.util.OperationNamingUtils;

public class AMFOperationModel
extends APIOperationModel {
    private final EndPoint endPoint;
    private final Operation operation;

    public AMFOperationModel(EndPoint endPoint, Operation operation) throws ModelGenerationException {
        this.endPoint = endPoint;
        this.operation = operation;
        this.description = this.buildOperationDescription();
        this.path = this.buildOperationPath();
        this.httpMethod = HTTPMethod.fromString(operation.method().value());
        this.name = this.buildName(this.httpMethod, this.path);
        this.uriParamsModel = this.buildUriParamsModel();
        this.queryParamsModel = this.buildQueryParamsModel();
        this.headersModel = this.buildHeadersModel();
        this.inputMetadataModel = this.buildInputMetadataModels();
        this.outputMetadataModel = this.buildOutputMetadataModels();
        this.securitySchemesModel = this.buildSecuritySchemesModel();
    }

    private List<APISecuritySchemeModel> buildSecuritySchemesModel() throws ModelGenerationException {
        List endPointSchemes = this.endPoint.security().stream().map(this::getScheme).filter(Objects::nonNull).collect(Collectors.toList());
        List operationSchemes = this.operation.security().stream().map(this::getScheme).filter(Objects::nonNull).collect(Collectors.toList());
        List selectedSchemes = this.selectSecuritySchemes(operationSchemes, endPointSchemes, new LinkedList());
        List<Object> securitySchemesModel = new ArrayList<AMFSecuritySchemeModel>();
        for (SecurityScheme securityScheme : selectedSchemes) {
            securitySchemesModel.add(new AMFSecuritySchemeModel(securityScheme));
        }
        securitySchemesModel = securitySchemesModel.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!selectedSchemes.isEmpty() && securitySchemesModel.isEmpty()) {
            throw new UnsupportedSecuritySchemeException(this.httpMethod.toString() + " " + this.path + ": None of the specified security schemes are supported.");
        }
        return securitySchemesModel;
    }

    private SecurityScheme getScheme(DomainElement domainElement) {
        if (domainElement instanceof ParametrizedSecurityScheme) {
            ParametrizedSecurityScheme securityScheme = (ParametrizedSecurityScheme)domainElement;
            if (securityScheme.scheme() == null) {
                return null;
            }
            if (securityScheme.scheme().isLink() && securityScheme.scheme().linkTarget().isPresent()) {
                return securityScheme.scheme().linkTarget().orElse(null);
            }
            return securityScheme.scheme();
        }
        return (SecurityScheme)domainElement;
    }

    private List<APITypeModel> buildOutputMetadataModels() {
        ArrayList<APITypeModel> models = new ArrayList<APITypeModel>();
        ArrayList<APITypeModel> defaultModel = new ArrayList<APITypeModel>();
        if (this.operation.responses() != null) {
            for (Response response : this.operation.responses()) {
                if (!response.statusCode().nonEmpty()) continue;
                if (response.statusCode().value().startsWith("2")) {
                    models.addAll(this.buildAMFTypeModel(response));
                    continue;
                }
                if (!response.statusCode().value().startsWith("default")) continue;
                defaultModel.addAll(this.buildAMFTypeModel(response));
            }
        }
        if (models.isEmpty()) {
            return defaultModel;
        }
        return models;
    }

    private List<APITypeModel> buildAMFTypeModel(Response response) {
        ArrayList<APITypeModel> models = new ArrayList<APITypeModel>();
        for (Payload payload : response.payloads()) {
            models.add(new AMFTypeModel((AnyShape)payload.schema(), payload.mediaType().value()));
        }
        return models;
    }

    private List<APITypeModel> buildInputMetadataModels() {
        ArrayList<APITypeModel> models = new ArrayList<APITypeModel>();
        if (this.operation.request() != null) {
            for (Payload payload : this.operation.request().payloads()) {
                models.add(new AMFTypeModel((AnyShape)payload.schema(), payload.mediaType().value()));
            }
        }
        return models;
    }

    private String buildName(HTTPMethod httpMethod, String path) {
        if (this.operation.name().nonEmpty() && StringUtils.isNotBlank((CharSequence)this.operation.name().value()) && !this.operation.name().value().equalsIgnoreCase(this.operation.method().value())) {
            return this.operation.name().value();
        }
        return OperationNamingUtils.buildFriendlyCanonicalOperationName(httpMethod, path);
    }

    private String buildOperationPath() {
        return AMFOperationModel.buildStandardPath(this.endPoint.path().value());
    }

    private String buildOperationDescription() {
        return this.operation.description().nonEmpty() ? this.operation.description().value() : this.endPoint.description().value();
    }

    private List<APIParameterModel> buildUriParamsModel() {
        AMFParameterModel parameterModel;
        LinkedList<APIParameterModel> list = new LinkedList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().uriParameters()) {
                parameterModel = new AMFParameterModel(x, ParameterType.URI, false);
                list.add(parameterModel);
            }
        }
        for (Parameter x : this.endPoint.parameters()) {
            parameterModel = new AMFParameterModel(x, ParameterType.URI, false);
            list.add(parameterModel);
        }
        return list;
    }

    private List<APIParameterModel> buildQueryParamsModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().queryParameters()) {
                AMFParameterModel parameterModel = new AMFParameterModel(x, ParameterType.QUERY, false);
                list.add(parameterModel);
            }
        }
        return list;
    }

    private List<APIParameterModel> buildHeadersModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().headers()) {
                AMFParameterModel parameterModel = new AMFParameterModel(x, ParameterType.HEADER, false);
                list.add(parameterModel);
            }
        }
        return list;
    }
}

