/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.DataNode;
import amf.client.model.domain.Example;
import amf.client.model.domain.FileShape;
import amf.client.model.domain.NilShape;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.ScalarNode;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.SchemaShape;
import amf.client.model.domain.Shape;
import amf.client.model.domain.UnionShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ArrayTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.MultipartTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ObjectTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.UnionTypeDefinition;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIPrimitiveTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFPrimitiveTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFTypeSchemaModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.util.AMFParserUtil;

public class AMFTypeModel
extends APITypeModel {
    private AnyShape shape;

    public AMFTypeModel(APIPrimitiveTypeModel primitiveTypeModel) {
        super(primitiveTypeModel);
    }

    public AMFTypeModel(AnyShape anyShape, String mediaType) {
        this.shape = anyShape;
        this.example = this.buildExample();
        this.enumValues = this.buildEnumValues();
        this.mediaType = this.getMediaTypeForStringOrNull(mediaType);
        this.APITypeSchemaModel = new AMFTypeSchemaModel(anyShape, this.mediaType);
        this.typeDefinitionClass = this.buildTypeDefinitionClass(this.mediaType);
    }

    private Class<? extends TypeDefinition> buildTypeDefinitionClass(MediaType mediaType) {
        Shape actualShape = AMFParserUtil.getActualShape((Shape)this.shape);
        if (actualShape instanceof ScalarShape || actualShape instanceof FileShape) {
            this.primitiveTypeModel = new AMFPrimitiveTypeModel((Shape)this.shape);
            return PrimitiveTypeDefinition.class;
        }
        if (MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)mediaType) && actualShape instanceof NodeShape && !((NodeShape)actualShape).properties().isEmpty()) {
            return MultipartTypeDefinition.class;
        }
        if (actualShape instanceof NodeShape || actualShape instanceof SchemaShape) {
            return ObjectTypeDefinition.class;
        }
        if (actualShape instanceof ArrayShape) {
            return ArrayTypeDefinition.class;
        }
        if (actualShape instanceof UnionShape) {
            return UnionTypeDefinition.class;
        }
        if (actualShape instanceof NilShape) {
            return null;
        }
        return EmptyTypeDefinition.class;
    }

    private String buildExample() {
        return !this.shape.examples().isEmpty() && ((Example)this.shape.examples().get(0)).value().nonEmpty() ? ((Example)this.shape.examples().get(0)).value().value() : null;
    }

    private List<String> buildEnumValues() {
        return !this.shape.values().isEmpty() ? this.shape.values().stream().map(this::getEnumValue).collect(Collectors.toList()) : null;
    }

    @Override
    public List<APIParameterModel> getParts() {
        if (this.typeDefinitionClass.equals(MultipartTypeDefinition.class)) {
            ArrayList<APIParameterModel> parts = new ArrayList<APIParameterModel>();
            for (PropertyShape s : ((NodeShape)this.shape).properties()) {
                parts.add(new AMFParameterModel(s, ParameterType.PART));
            }
            return parts;
        }
        return Collections.emptyList();
    }

    @Override
    public APITypeModel getInnerType() {
        if (this.shape instanceof ArrayShape) {
            return new AMFTypeModel((AnyShape)((ArrayShape)this.shape).items(), null);
        }
        return null;
    }

    @Override
    public List<APITypeModel> getUnionTypes() {
        if (this.shape instanceof UnionShape) {
            ArrayList<APITypeModel> list = new ArrayList<APITypeModel>();
            for (Shape x : ((UnionShape)this.shape).anyOf()) {
                AMFTypeModel amfTypeParser = new AMFTypeModel((AnyShape)x, null);
                list.add(amfTypeParser);
            }
            return list;
        }
        return Collections.emptyList();
    }

    private String getEnumValue(DataNode x) {
        if (x instanceof ScalarNode) {
            return ((ScalarNode)x).value().value();
        }
        throw new IllegalArgumentException("Enum type not supported");
    }
}

