/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.SchemaShape;
import amf.core.model.domain.Shape;
import amf.plugins.xml.transformer.TypeToXmlSchema;
import java.io.StringWriter;
import java.io.Writer;
import javax.ws.rs.core.MediaType;
import org.apache.ws.commons.schema.XmlSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeSchemaModel;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class AMFTypeSchemaModel
extends APITypeSchemaModel {
    public AMFTypeSchemaModel(AnyShape shape, MediaType mediaType) {
        this.typeSchema = this.buildTypeSchema(shape, mediaType);
    }

    private TypeSchema buildTypeSchema(AnyShape shape, MediaType mediaType) {
        SchemaShape schemaShape;
        TypeSchema newTypeSchema = shape instanceof SchemaShape && ((SchemaShape)shape).raw().nonEmpty() ? (AMFTypeSchemaModel.isXmlSchemaShape(schemaShape = (SchemaShape)shape) ? this.buildXmlTypeSchema(schemaShape) : new JsonTypeSchema(schemaShape.raw().value())) : (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType) ? new JsonTypeSchema(shape.buildJsonSchema()) : (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType) ? this.buildXmlTypeSchema(shape) : new JsonTypeSchema(shape.buildJsonSchema())));
        return newTypeSchema;
    }

    public static boolean isXmlSchemaShape(SchemaShape schemaShape) {
        return schemaShape.raw().nonEmpty() && XmlUtils.isXmlSchema(schemaShape.raw().value());
    }

    private TypeSchema buildXmlTypeSchema(SchemaShape schemaShape) {
        String elementName = schemaShape.annotations().fragmentName().orElse(null);
        String path = schemaShape.location().orElse(null);
        return new XmlTypeSchema(schemaShape.raw().value(), elementName, path);
    }

    private TypeSchema buildXmlTypeSchema(AnyShape anyShape) {
        XmlSchema xmlSchema = TypeToXmlSchema.transform((String)"root", (Shape)anyShape._internal());
        xmlSchema.setTargetNamespace("http://validationnamespace.raml.org");
        StringWriter schemaWriter = new StringWriter();
        xmlSchema.write((Writer)schemaWriter);
        String schemaString = schemaWriter.toString();
        return new XmlTypeSchema(schemaString);
    }
}

