/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.connectormodel.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.NotSupportedScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APISecuritySchemeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.security.RPOauth2FlowsNaming;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.security.RPSecuritySchemesNaming;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.security.SecurityScheme;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;

public class RPSecuritySchemeModel
extends APISecuritySchemeModel {
    private final SecurityScheme securityScheme;

    public RPSecuritySchemeModel(SecurityScheme securityScheme) {
        this.securityScheme = securityScheme;
        this.displayName = securityScheme.name();
        this.securitySchemeClass = this.buildSecuritySchemeClass();
        this.customHeaders = this.buildCustomHeadersModel();
        this.customQueryParams = this.buildCustomQueryParamsModel();
        this.accessTokenUri = this.buildAccessTokenUri();
        this.authorizationUri = this.buildAuthorizationTokenUri();
        this.scopes = this.buildScopes();
    }

    private List<String> buildScopes() {
        if (this.securityScheme.settings() != null) {
            return this.securityScheme.settings().scopes();
        }
        return Collections.emptyList();
    }

    private String buildAuthorizationTokenUri() {
        if (this.securityScheme.settings() != null) {
            return RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)this.securityScheme.settings().authorizationUri());
        }
        return null;
    }

    private String buildAccessTokenUri() {
        if (this.securityScheme.settings() != null) {
            return RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)this.securityScheme.settings().accessTokenUri());
        }
        return null;
    }

    private Class<? extends APISecurityScheme> buildSecuritySchemeClass() {
        String schemeType = this.securityScheme.type();
        if (RPSecuritySchemesNaming.isBasicAuth(schemeType)) {
            return BasicAuthScheme.class;
        }
        if (RPSecuritySchemesNaming.isPassThrough(schemeType)) {
            return PassThroughScheme.class;
        }
        if (RPSecuritySchemesNaming.isOauth2(schemeType)) {
            for (String grant : this.securityScheme.settings().authorizationGrants()) {
                if (RPOauth2FlowsNaming.isAuthorizationCode(grant)) {
                    return OAuth2AuthorizationCodeScheme.class;
                }
                if (!RPOauth2FlowsNaming.isClientCredentials(grant)) continue;
                return OAuth2ClientCredentialsScheme.class;
            }
        } else {
            if (RPSecuritySchemesNaming.isDigest(schemeType)) {
                return DigestAuthenticationScheme.class;
            }
            if (RPSecuritySchemesNaming.isCustom(schemeType)) {
                return CustomAuthenticationScheme.class;
            }
        }
        return NotSupportedScheme.class;
    }

    private List<APIParameterModel> buildCustomQueryParamsModel() {
        if (this.securityScheme.describedBy() != null) {
            return this.getParameterList(this.securityScheme.describedBy().queryParameters(), ParameterType.QUERY);
        }
        return Collections.emptyList();
    }

    private List<APIParameterModel> buildCustomHeadersModel() {
        if (this.securityScheme.describedBy() != null) {
            return this.getParameterList(this.securityScheme.describedBy().headers(), ParameterType.HEADER);
        }
        return Collections.emptyList();
    }

    private List<APIParameterModel> getParameterList(List<TypeDeclaration> typeDeclarations, ParameterType parameterType) {
        ArrayList<APIParameterModel> parametersModel = new ArrayList<APIParameterModel>();
        for (TypeDeclaration td : typeDeclarations) {
            parametersModel.add(new RPParameterModel(td, parameterType, false));
        }
        return parametersModel;
    }
}

