/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.parameter;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;

public class PartParameter extends Parameter {

  private String partName;
  private String partFilename;
  private String partContentType;

  private String partNameParameterName;
  private String partFilenameParameterName;

  private Parameter partNameParameter = null;
  private Parameter partFilenameParameter = null;

  public PartParameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition) {
    super(externalName, externalName, parameterType, typeDefinition, null, false, null, false, null);
  }

  public String getPartName() {
    return partName;
  }

  public void setPartName(String partName) {
    this.partName = partName;
  }

  public String getPartFilename() {
    return partFilename;
  }

  public void setPartFilename(String partFilename) {
    this.partFilename = partFilename;
  }

  public String getPartContentType() {
    return partContentType;
  }

  public void setPartContentType(String partContentType) {
    this.partContentType = partContentType;
  }

  public void setPartNameParameterName(String partNameParameterName) {
    this.partNameParameterName = partNameParameterName;
  }

  public void setPartFilenameParameterName(String partFilenameParameterName) {
    this.partFilenameParameterName = partFilenameParameterName;
  }

  public Parameter getPartNameParameter() {
    if (partNameParameter == null && isNotBlank(partNameParameterName)) {
      partNameParameter = new Parameter(partNameParameterName, partNameParameterName, ParameterType.PART_PROPERTY,
                                        TypeDefinition.simpleStringType(), null, false, null, false, null);
    }

    return partNameParameter;
  }

  public Parameter getPartFilenameParameter() {
    if (partFilenameParameter == null && isNotBlank(partFilenameParameterName)) {
      partFilenameParameter = new Parameter(partFilenameParameterName, partFilenameParameterName, ParameterType.PART_PROPERTY,
                                            TypeDefinition.simpleStringType(), null, false, null, false, null);
    }

    return partFilenameParameter;
  }
}
