/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import org.mule.connectivity.restconnect.internal.descriptor.model.BaseUriDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.MultipleBaseUriDescriptor;

import java.util.ArrayList;
import java.util.List;

import javax.validation.constraints.NotNull;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorBaseUriParser {

  private static final String REST_CONNECT_BASE_URI = "http://a.ml/vocabularies/restConnect#baseUri";
  private static final String REST_CONNECT_BASE_URI_TYPE = "http://a.ml/vocabularies/restConnect#baseUriType";
  private static final String REST_CONNECT_MULTIPLE_BASE_URI = "http://a.ml/vocabularies/restConnect#multipleBaseUri";
  private static final String REST_CONNECT_DEFAULT_BASE_URI = "http://a.ml/vocabularies/restConnect#defaultBaseUri";
  private static final String API_CONTRACT_URL = "http://a.ml/vocabularies/apiContract#url";

  public BaseUriDescriptor parseBaseUri(DialectDomainElement encodes) {
    DialectDomainElement baseUriElement = encodes
        .getObjectPropertyUri(REST_CONNECT_BASE_URI)
        .stream()
        .findFirst()
        .orElse(null);

    if (baseUriElement == null) {
      return null;
    }

    return new BaseUriDescriptor(
                                 getUri(baseUriElement),
                                 getType(baseUriElement),
                                 getMultipleBaseUris(baseUriElement));
  }

  private String getType(@NotNull DialectDomainElement baseUriElement) {
    List<Object> types = baseUriElement.getScalarByPropertyUri(REST_CONNECT_BASE_URI_TYPE);
    return types.isEmpty() ? null : types.get(0).toString();
  }

  private String getUri(@NotNull DialectDomainElement baseUriElement) {
    List<Object> urls = baseUriElement.getScalarByPropertyUri(API_CONTRACT_URL);
    return urls.isEmpty() ? null : urls.get(0).toString();
  }

  private List<MultipleBaseUriDescriptor> getMultipleBaseUris(@NotNull DialectDomainElement baseUriElement) {
    List<DialectDomainElement> multipleBaseUris = baseUriElement.getObjectPropertyUri(REST_CONNECT_MULTIPLE_BASE_URI);

    List<MultipleBaseUriDescriptor> multipleBaseUriDescriptorList = new ArrayList<>(multipleBaseUris.size());

    for (DialectDomainElement alternativeServerElement : multipleBaseUris) {
      String uriId = DescriptorParserUtils.parseElementCoreName(alternativeServerElement);
      String url = alternativeServerElement.getScalarByPropertyUri(API_CONTRACT_URL).get(0).toString();
      List<Object> defaults = alternativeServerElement.getScalarByPropertyUri(REST_CONNECT_DEFAULT_BASE_URI);
      boolean defaultUri = !defaults.isEmpty() && Boolean.parseBoolean(defaults.get(0).toString());

      MultipleBaseUriDescriptor multipleBaseUriDescriptor = new MultipleBaseUriDescriptor(uriId, url, defaultUri);
      multipleBaseUriDescriptorList.add(multipleBaseUriDescriptor);
    }

    return multipleBaseUriDescriptorList;
  }
}
