/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.InPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.OutPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.PaginationParameter;
import org.mule.connectors.restconnect.commons.api.operation.paging.MarkerPagingProvider;

import java.nio.file.Path;

import static org.apache.commons.lang3.StringUtils.EMPTY;

public class SdkMarkerPaginationOperation extends AbstractSdkPaginationOperation {

  public static final String NEXT_TOKEN_EXPRESSION = "nextTokenExpression";
  public static final String NEXT_TOKEN_PARAM_NAME = "nextTokenParamName";

  public SdkMarkerPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                      ConnectorOperation operation) {
    super(outputDir, connectorModel, sdkConnector, operation);
  }

  @Override
  public String getInitialPagingParameterSummary() {
    return EMPTY;
  }

  @Override
  public ParameterSpec generateInitialPagingParameter() {
    return null;
  }

  @Override
  public CodeBlock getPagingMethodOperation() {
    CodeBlock.Builder paginationBody = CodeBlock.builder();
    paginationBody.addStatement(
                                "return new $T($S, $S, requestFactory, expressionLanguage, streamingHelper, $S, org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON, config.getEncoding(), overrides.getResponseTimeoutAsMillis())",
                                getPagingProvider(),
                                generateToeknParameter().name,
                                getNextTokenExpression(),
                                getPayloadExpression());
    return paginationBody.build();
  }

  @Override
  public Class getPagingProvider() {
    return MarkerPagingProvider.class;
  }

  private String getNextTokenExpression() {
    PaginationParameter parameter = getPagination().getParameter(NEXT_TOKEN_EXPRESSION);

    return (parameter == null) ? null : ((InPaginationParameter) parameter).getValueExtraction().getContent();
  }

  @Override
  public String getTokenParamName() {
    PaginationParameter parameter = getPagination().getParameter(NEXT_TOKEN_PARAM_NAME);

    return (parameter == null) ? null : ((OutPaginationParameter) parameter).getValue();
  }

  @Override
  public String getInitialParamName() {
    return NEXT_TOKEN_EXPRESSION;
  }

  private ParameterSpec generateToeknParameter() {
    return ParameterSpec
        .builder(String.class, getInitialParamName())
        .build();
  }
}
