/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;

import java.nio.file.Path;

public class SdkOperation extends AbstractSdkOperation {

  public SdkOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) {
    super(outputDir, connectorModel, sdkConnector, operation);
  }

  public FieldSpec generateExpressionLanguageField() {
    return null;
  }

  public ParameterSpec generateInitialPagingParameter() {
    return null;
  }

  public TypeName generateMethodReturn() {
    return null;
  }

  public CodeBlock generateOperationMethodBody() {
    CodeBlock.Builder methodBody = super.generateCommonOperationMethodBody();

    if (!isVoidOperation() && (getSdkOutputMetadata() != null || operationMethodRequiresBody())) {
      methodBody
          .addStatement("doRequest(connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback)");
    } else {
      methodBody
          .addStatement("doVoidRequest(connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback)");
    }

    return methodBody.build();
  }
}
