/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static org.apache.commons.lang3.StringUtils.isBlank;
import static org.mule.connectivity.restconnect.internal.validation.ValidationRule.Level.ERROR;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.LinkedList;
import java.util.List;

public class BaseJavaPackageMustBeValidRule extends PreValidationRule {

  //R006
  public BaseJavaPackageMustBeValidRule() {
    super("Descriptor baseJavaPackage must ve a valid java package name",
          "When present in the connector descriptor, baseJavaPackage property must be a valid java package.",
          ERROR);
  }

  @Override
  public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationResult> validationResults = new LinkedList<>();

    String javaPackage = connectorDescriptor.getBaseJavaPackage();

    if (isBlank(javaPackage)) {
      return validationResults;
    }

    String validJavaPackage = JavaUtils.removeJavaPackageUnwantedCharacters(javaPackage);

    if (!javaPackage.equalsIgnoreCase(validJavaPackage)) {
      validationResults.add(getValidationError());
    }

    return validationResults;
  }

  private ValidationResult getValidationError() {
    return new ValidationResult(this, "Descriptor baseJavaPackage");
  }
}
