/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.api;

import java.io.File;
import java.nio.file.Path;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorModelBuilder;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParser;
import org.mule.connectivity.restconnect.internal.templating.TemplateEntity;
import org.mule.connectivity.restconnect.internal.util.AMFWrapper;
import org.mule.connectivity.restconnect.internal.validation.ValidationEngine;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ApiParser;

public class RestConnect {
    private RestConnect() {
    }

    public static ConnectorModel getConnectorModel(File descriptor, File spec, SpecFormat format, Parser parser, String rootDir) throws ModelGenerationException {
        AMFWrapper.initialize();
        ValidationEngine validationEngine = new ValidationEngine();
        DescriptorParser descriptorParser = new DescriptorParser();
        ConnectorDescriptor connectorDescriptor = descriptorParser.parseConnectorDescriptor(descriptor);
        APIModel apiModel = ApiParser.parseModel(spec, format, parser, rootDir);
        boolean preValidationSuccess = validationEngine.preValidate(connectorDescriptor, apiModel);
        try {
            ConnectorModelBuilder connectorModelBuilder = new ConnectorModelBuilder();
            ConnectorModel connectorModel = connectorModelBuilder.buildConnectorModel(apiModel, connectorDescriptor);
            if (preValidationSuccess && validationEngine.postValidate(connectorModel)) {
                return connectorModel;
            }
            throw new ModelGenerationException("There are validation errors");
        }
        catch (Exception e) {
            if (preValidationSuccess) {
                throw e;
            }
            throw new ModelGenerationException("There are validation errors");
        }
    }

    public static void generateConnector(ConnectorModel connectorModel, ConnectorType connectorType, Path outputDir, Path descriptorPath) throws TemplatingException {
        TemplateEntity.getTemplateEngine(connectorType, connectorModel, outputDir, descriptorPath).applyTemplates();
    }
}

